/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.epl;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.core.tunneling.SSHTunnelFactory;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org2.eclipse.php.internal.debug.core.daemon.DebugDaemon;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org2.eclipse.php.internal.debug.ui.util.ImageDescriptorRegistry;

public class PHPDebugEPLPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.php.debug.epl";
    public static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"com.aptana.php.debug.epl/debug"));
    private static PHPDebugEPLPlugin plugin;
    private static boolean fLaunchChangedAutoRemoveLaunches;
    private static boolean fIsSupportingMultipleDebugAllPages;
    private boolean fInitialAutoRemoveLaunches;
    private ImageDescriptorRegistry fImageDescriptorRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.init();
    }

    public void stop(BundleContext context) throws Exception {
        XDebugLaunchListener.shutdown();
        DBGpProxyHandler.instance.unregister();
        try {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)plugin, (Throwable)e);
        }
        super.stop(context);
        plugin = null;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", this.fInitialAutoRemoveLaunches);
        SSHTunnelFactory.closeAllConnections();
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
            this.fImageDescriptorRegistry = null;
        }
    }

    private void init() {
        Job debuggerStartJob = new Job("PHP debugger initialization"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
                    PHPDebugEPLPlugin.this.fInitialAutoRemoveLaunches = preferenceStore.getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
                    preferenceStore.addPropertyChangeListener((IPropertyChangeListener)new AutoRemoveOldLaunchesListener());
                    PHPDebugEPLPlugin.createDefaultPHPServer();
                    XDebugPreferenceMgr.setDefaults();
                    DebugDaemon.getDefault().startDaemons(null);
                    XDebugLaunchListener.getInstance();
                    DBGpProxyHandler.instance.configure();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)plugin, (String)"Error while initiating the PHP debug (EPL) plugin", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        debuggerStartJob.setSystem(true);
        debuggerStartJob.schedule();
    }

    public static PHPDebugEPLPlugin getDefault() {
        return plugin;
    }

    public static boolean getStopAtFirstLine() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "com.aptana.php.debug.eplstop_at_first_line_string", true, PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static boolean getDebugInfoOption() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "com.aptana.php.debug.eplrun_with_debug_info", true, PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static boolean getOpenInBrowserOption() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "com.aptana.php.debug.eplopen_in_browser", true, PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static String getCurrentDebuggerId() {
        return Platform.getPreferencesService().getString(PLUGIN_ID, "com.aptana.php.debug.php_debugger_id", "org2.eclipse.php.debug.core.xdebugDebugger", PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static boolean getOpenDebugViewsOption() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "com.aptana.php.debug.eplopen_debug_views", true, PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static int getDebugPort(String debuggerId) {
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
        if (debuggerConfiguration == null) {
            return -1;
        }
        return debuggerConfiguration.getPort();
    }

    public static String getWorkspaceDefaultServer() {
        return "";
    }

    public static void createDefaultPHPServer() {
    }

    public static boolean supportsMultipleDebugAllPages() {
        return fIsSupportingMultipleDebugAllPages;
    }

    public static void setMultipleDebugAllPages(boolean supported) {
        fIsSupportingMultipleDebugAllPages = supported;
    }

    public static void setDisableAutoRemoveLaunches(boolean disableAutoRemoveLaunches) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches") == disableAutoRemoveLaunches) {
            fLaunchChangedAutoRemoveLaunches = true;
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", !disableAutoRemoveLaunches);
        }
    }

    public boolean getInitialAutoRemoveLaunches() {
        return this.fInitialAutoRemoveLaunches;
    }

    public static String getDebugHosts() {
        return Platform.getPreferencesService().getString(PLUGIN_ID, "com.aptana.php.debug.eplclient_ip", "127.0.0.1", PHPDebugEPLPlugin.getPreferenceContexts());
    }

    public static IEclipsePreferences getInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static void logError(Throwable t) {
        PHPDebugEPLPlugin.logError(t.getLocalizedMessage(), t);
    }

    public static void logError(String msg, Throwable t) {
        IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (String)msg, (Throwable)t, (String)"com.aptana.php.debug/debug");
    }

    public static void logError(String msg) {
        IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (String)msg, (String)"com.aptana.php.debug/debug");
    }

    public static void logWarning(String msg) {
        IdeLog.logWarning((Plugin)PHPDebugEPLPlugin.getDefault(), (String)msg, (String)"com.aptana.php.debug/debug");
    }

    public static void log(IStatus status) {
        IdeLog.log((Plugin)PHPDebugEPLPlugin.getDefault(), (IStatus)status, (String)"com.aptana.php.debug/debug");
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIUtils.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return UIUtils.getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        return UIUtils.getActiveShell();
    }

    public static Display getStandardDisplay() {
        return UIUtils.getDisplay();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (PHPDebugEPLPlugin.getDefault().fImageDescriptorRegistry == null) {
            PHPDebugEPLPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return PHPDebugEPLPlugin.getDefault().fImageDescriptorRegistry;
    }

    private static IScopeContext[] getPreferenceContexts() {
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    private class AutoRemoveOldLaunchesListener
    implements IPropertyChangeListener {
        private AutoRemoveOldLaunchesListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.debug.ui.auto_remove_old_launches".equals(event.getProperty())) {
                if (fLaunchChangedAutoRemoveLaunches) {
                    fLaunchChangedAutoRemoveLaunches = false;
                } else if (event.getNewValue() instanceof Boolean) {
                    PHPDebugEPLPlugin.this.fInitialAutoRemoveLaunches = (Boolean)event.getNewValue();
                }
            }
        }
    }
}

